<?php
/**
 * Mu Roulette
 * https://webenginecms.org/
 * 
 * @version 1.0.0
 * @author Lautaro Angelico <http://lautaroangelico.com/>
 * @copyright (c) 2013-2019 Lautaro Angelico, All Rights Reserved
 * @build w3c8c718b75a0f1fa1a557f7f9d70877
 */

if(!isLoggedIn()) redirect(1,'login');

echo '<div class="page-title"><span>'.lang('roulette_title_ticket').'</span></div>';

try {
	
	$MuRoulette = new \Plugin\MuRoulette\MuRoulette();
	$MuRoulette->setUsername($_SESSION['username']);
	$accountCharacters = $MuRoulette->getAccountCharacterList();
	
	$freeSpins = $MuRoulette->getUnusedTickets();
	
	if(check_value($_POST['roulette_submit'])) {
		try {
			$MuRoulette->setUserid($_SESSION['userid']);
			$MuRoulette->setCharacter($_POST['character_name']);
			if(is_array($freeSpins)) {
				$MuRoulette->useFreeSpin();
			} else {
				$MuRoulette->buyTicket();
			}
		} catch(Exception $ex) {
			message('error', $ex->getMessage());
		}
	}
	
	echo '<form action="'.__ROULETTE_HOME__.'ticket/" method="post">';
		echo '<div class="roulette-ticket">';
			echo '<div class="roulette-ticket-title">';
				echo lang('roulette_txt_1');
			echo '</div>';
			echo '<div class="roulette-ticket-info">';
				echo '<div class="roulette-ticket-info-block">';
					echo '<strong>'.lang('roulette_txt_2').'</strong>';
					echo '<br />';
					echo langf('roulette_txt_6', array($MuRoulette->getTicketCost()));
				echo '</div>';
				echo '<div class="roulette-ticket-info-block">';
					echo '<strong>'.lang('roulette_txt_3').'</strong>';
					echo '<br />';
					echo '<select class="form-control" name="character_name">';
					foreach($accountCharacters as $character) {
						echo '<option value="'.$character.'">'.$character.'</option>';
					}
					echo '</select>';
				echo '</div>';
				echo '<div class="roulette-ticket-info-block free-spins">';
					if(is_array($freeSpins)) {
						echo langf('roulette_txt_5', array(count($freeSpins)));
					}
				echo '</div>';
				echo '<div class="roulette-ticket-info-block">';
					echo '<button type="submit" name="roulette_submit" value="submit" class="btn btn-roulette">'.lang('roulette_txt_4').'</button>';
				echo '</div>';
			echo '</div>';
		echo '</div>';
	echo '</form>';
	
	echo '<div class="text-center">';
		echo '<a href="'.__ROULETTE_HOME__.'results/" class="btn btn-primary">'.lang('roulette_txt_14').'</a>';
	echo '</div>';
	
	
} catch(Exception $ex) {
	message('error', $ex->getMessage());
}